﻿using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineListRepository : IMedicineListRepository
    {
        private FarmatikoDataContext _context;
        public MedicineListRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(MedicineList medicineList)
        {
            _context.MedicineLists.Add(medicineList);
            _context.SaveChangesAsync();
        }

        public MedicineList CheckMedicine(string Name)
        {
            return (MedicineList)_context.MedicineLists.Where(medicineList => medicineList.Medicine.Name.Equals(Name));
        }

        public MedicineList GetAll()
        {
            return (MedicineList)_context.MedicineLists.Include(list => list.Medicine).Include(list => list.HasMedicine);
        }

        public void Remove(MedicineList medicineList)
        {
            //throw new NotImplementedException();
            //Implement later
        }
    }
}
