﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineRepository : IMedicineRepository
    {
        private FarmatikoDataContext _context;
        public MedicineRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(Medicine Medicine)
        {
            _context.Add(Medicine);
            _context.SaveChangesAsync();
        }

        public IEnumerable<Medicine> GetAll()
        {
            return _context.Medicines.Include(medicine => medicine.Name).Include(medicine => medicine.Strength).Include(medicine => medicine.Form);
        }

        public Medicine GetByName(string Name)
        {
            return (Medicine)_context.Medicines.Where(medicine => medicine.Name == Name);
        }

        public void Remove(string medicine)
        {
            Medicine med = (Medicine)_context.Medicines.Where(medicine => medicine.Name.Equals(medicine));
            _context.Medicines.Remove(med);
        }
    }
}
