import { Component, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { HealthFacilities } from '../models/HealthFacilities';
@Component({
  selector: 'app-counter-component',
  templateUrl: './counter.component.html',
  styleUrls: ['./counter.component.css']
})
export class CounterComponent {
  public facilities: HealthFacilities[];

  constructor(http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    http.get<HealthFacilities[]>(baseUrl + 'HealthFacilities').subscribe(result => {
      this.facilities = result;
    }, error => console.error(error));
  } 
}