﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System.Collections.Generic;

namespace FarmatikoServices.Services
{
    public class PharmacyService : IPharmacyService
    {
        private IPharmacyRepository _pharmacyRepository;
        public PharmacyService(IPharmacyRepository pharmacyRepository)
        {
            _pharmacyRepository = pharmacyRepository;
        }
        public void Add(Pharmacy pharmacy)
        {
            if(pharmacy != null)
            {
                _pharmacyRepository.Add(pharmacy);
            }
        }

        public IEnumerable<Pharmacy> GetAll()
        {
            return _pharmacyRepository.GetAll();
        }

        public ICollection<Pharmacy> GetPharmacies()
        {
            return _pharmacyRepository.GetPharmacies();
        }

        public void Remove(Pharmacy pharmacy)
        {
            _pharmacyRepository.Remove(pharmacy);
        }

        public void UpdatePharmacy(Pharmacy pharmacy, string Name)
        {
            if(pharmacy != null && Name != null)
            {
                _pharmacyRepository.UpdatePharmacy(pharmacy, Name);
            }
        }
    }
}
