using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.SpaServices.AngularCli;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using FarmatikoData;
using Microsoft.EntityFrameworkCore;
using FarmatikoServices;
using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.FarmatikoRepo;
using FarmatikoServices.FarmatikoServiceInterfaces;
using FarmatikoServices.Services;

namespace Farmatiko
{
    public class Startup
    {
        readonly string MyAllowSpecificOrigins = "_myAllowSpecificOrigins";

        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            services.AddCors(options =>
            {
                options.AddPolicy(name: MyAllowSpecificOrigins,
                                  builder =>
                                  {
                                      builder.AllowAnyHeader().AllowAnyMethod().AllowAnyOrigin();
                                  });
            });

            services.AddControllersWithViews();
            // In production, the Angular files will be served from this directory
            services.AddSpaStaticFiles(configuration =>
            {
                configuration.RootPath = "ClientApp/dist";
            });
            var connectionString = Configuration.GetSection("ConnectionStrings").GetValue<string>("FarmatikoConnection");
            services.AddEntityFrameworkNpgsql().AddDbContext<FarmatikoDataContext>(opt => opt.UseNpgsql(connectionString));

            services.AddTransient<IHealthFacilityRepository, HealthFacilityRepository>();
            services.AddTransient<IHealthFacilityService, HealthFacilityService>();

            services.AddTransient<IHealthcareWorkerRepository, HealthcareWorkerRepository>();
            services.AddTransient<IHealthcareWorkerService, HealthcareWorkerService>();

            services.AddTransient<IMedicineRepository, MedicineRepository>();
            services.AddTransient<IMedicineService, MedicineService>();

            services.AddTransient<IMedicineListRepository, MedicineListRepository>();
            services.AddTransient<IMedicineListService, MedicineListService>();

            services.AddTransient<IPandemicRepository, PandemicRepository>();
            services.AddTransient<IPandemicService, PandemicService>();

            services.AddTransient<IPharmacyHeadRepository, PharmacyHeadRepository>();
            services.AddTransient<IPharmacyHeadService, PharmacyHeadService>();

            services.AddTransient<IPharmacyRepository, PharmacyRepository>();
            services.AddTransient<IPharmacyService, PharmacyService>();
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Error");
                // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
                app.UseHsts();
            }

            app.UseHttpsRedirection();
            app.UseStaticFiles();
            if (!env.IsDevelopment())
            {
                app.UseSpaStaticFiles();
            }

            app.UseRouting();

            app.UseCors(MyAllowSpecificOrigins);

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllerRoute(
                    name: "default",
                    pattern: "{controller}/{action=Index}/{id?}");
            });

            app.UseSpa(spa =>
            {
                // To learn more about options for serving an Angular SPA from ASP.NET Core,
                // see https://go.microsoft.com/fwlink/?linkid=864501

                spa.Options.SourcePath = "ClientApp";

                if (env.IsDevelopment())
                {
                    spa.UseAngularCliServer(npmScript: "start");
                }
            });
        }
    }
}
