﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FarmatikoData.FarmatikoRepo
{
    public class PharmacyRepository : IPharmacyRepository
    {
        private FarmatikoDataContext _context;

        public PharmacyRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(Pharmacy pharmacy)
        {
            _context.Pharmacies.Add(pharmacy);
            _context.SaveChangesAsync();
        }
        //Just for users
        public IEnumerable<Pharmacy> GetAll()
        {
            return _context.Pharmacies.OrderBy(x => x.Name);
        }

        public ICollection<Pharmacy> GetPharmacies()
        {
            return (ICollection<Pharmacy>)_context.Pharmacies.Select(pharmacy => new
            {
                pharmacy.Name,
                pharmacy.Address,
                pharmacy.Location,
                pharmacy.WorkAllTime
            });
        }

        public void Remove(Pharmacy pharmacy)
        {
            var pharma = _context.Pharmacies.Where(pharm => pharm.Equals(pharmacy));
            _context.Pharmacies.Remove((Pharmacy)pharma);
            _context.SaveChangesAsync();
        }

        public void UpdatePharmacy(Pharmacy pharmacy, string Name)
        {
            var oldPharmacy = _context.Pharmacies.Where(pharma => pharma.Name.Equals(Name));
            _context.Pharmacies.Remove((Pharmacy)oldPharmacy);
            _context.Pharmacies.Add(pharmacy);
            _context.SaveChangesAsync();
        }
    }
}
