﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FarmatikoServices.Services
{
    public class PharmacyHeadService : IPharmacyHeadService
    {
        private IPharmacyHeadRepository _pharmacyHeadRepository;
        public PharmacyHeadService(IPharmacyHeadRepository pharmacyHeadRepository)
        {
            _pharmacyHeadRepository = pharmacyHeadRepository;
        }

        public void Add(PharmacyHead pharmacyHead)
        {
            if (pharmacyHead != null)
            {
                _pharmacyHeadRepository.Add(pharmacyHead);
            }
        }

        public IQueryable<PharmacyHead> GetAllPharmacies(string NameOfPharmacyHead)
        {
            if(NameOfPharmacyHead != null)
            {
                IQueryable<PharmacyHead> Pharmacy = _pharmacyHeadRepository.GetAllPharmacies(NameOfPharmacyHead);
                if (Pharmacy != null)
                {
                    return Pharmacy;
                }
            }
            return null;
        }

        public IQueryable<PharmacyHead> GetPharmacyByName(string Name)
        {
            if(Name != null)
            {
                IQueryable<PharmacyHead> PharmacyHead = _pharmacyHeadRepository.GetPharmacyByName(Name);
                if (PharmacyHead != null)
                    return PharmacyHead;
            }
            return null;
        }

        public IQueryable<MedicineList> GetPharmacyMedicines(string NameOfPharmacy)
        {
            if(NameOfPharmacy != null)
            {
                IQueryable<MedicineList> Medicines = _pharmacyHeadRepository.GetPharmacyMedicines(NameOfPharmacy);
                if (Medicines != null)
                    return Medicines;
            }
            return null;
        }

        public void Remove(PharmacyHead pharmacyHead, string Name)
        {
            if (pharmacyHead != null && Name != null)
            {
                _pharmacyHeadRepository.Remove(pharmacyHead, Name);
            }
        }
    }
}
