﻿using System.Linq;
using System.Threading.Tasks;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    [ApiController]
    [Route("api/[action]")]
    public class FarmatikoController : Controller
    {
        private readonly IService _service;
        public FarmatikoController(IService service)
        {
            _service = service;
        }
        // Workers
        //Get
        [HttpGet]
        [Route("/api/workers")]
        public async Task<IQueryable<HealthcareWorkers>> GetWorkers()
        {
            return await _service.GetAllWorkers();
        }
        [HttpGet]
        [Route("/api/workers/search/{Query}")]
        public async Task<IQueryable<HealthcareWorkers>> SearchWorkers(string Query)
        {
            return await _service.SearchWorkers(Query);
        }
        [HttpGet]
        [Route("/api/workers/{id}")]
        public async Task<HealthcareWorkers> GetWorker(int Id)
        {
            return await _service.GetWorker(Id);
        }
        //Post


        //Facilities
        //Get
        [HttpGet]
        [Route("/api/facilities")]
        public async Task<IQueryable<HealthFacilities>> GetFacilities()
        {
            return await _service.GetFacilities();
        }
        [HttpGet]
        [Route("/api/facilities/search/{Query}")]
        public async Task<IQueryable<HealthFacilities>> SearchFacilities(string Query)
        {
            return await _service.SearchFacilities(Query);
        }
        [HttpGet]
        [Route("/api/facilities/{Id}")]
        public async Task<HealthFacilities> GetFacility(int Id)
        {
            return await _service.GetFacility(Id);
        }
        //Post

        //Medicine
        //Get
        [HttpGet]
        [Route("/api/medicines")]
        public async Task<IQueryable<Medicine>> GetMedicines()
        {
            return await _service.GetMedicines();
        }
        [HttpGet]
        [Route("/api/medicines/search/{Query}")]
        public async Task<IQueryable<Medicine>> SearchMedicines(string Query)
        {
            return await _service.SearchMedicines(Query);
        }
        [HttpGet]
        [Route("/api/medicines/{Id}")]
        public async Task<Medicine> GetMedicine(int Id)
        {
            return await _service.GetMedicine(Id);
        }
        //POST

        //Pandemic
        [HttpGet]
        [Route("/api/pandemic")]
        public async Task<Pandemic> GetPandemic()
        {
            return await _service.GetPandemic();
        }
        //Pharmacy
        //GET
        [HttpGet]
        [Route("/api/pharmacy")]
        public async Task<IQueryable<Pharmacy>> GetPharmacies()
        {
            return await _service.GetPharmacies();
        }
        [HttpGet]
        [Route("/api/pharmacy/search/{Query}")]
        public async Task<IQueryable<Pharmacy>> SearchPharmacies(string Query)
        {
            return await _service.SearchPharmacies(Query);
        }
        [HttpGet]
        [Route("/api/pharmacy/{Id}")]
        public async Task<Pharmacy> GetPharmacy(int Id)
        {
            return await _service.GetPharmacy(Id);
        }

    }
}
