﻿using FarmatikoData.Models;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoData.FarmatikoRepoInterfaces
{
    public interface IRepository
    {
        //GET
        Task<IQueryable<HealthcareWorkers>> GetAllWorkers();
        Task<IQueryable<HealthFacilities>> GetFacilities();
        Task<HealthFacilities> GetFacility(int Id);
        Task<Medicine> GetMedicine(int Id);
        Task<IQueryable<Medicine>> GetMedicines();
        Task<Pandemic> GetPandemic();
        Task<IQueryable<Pharmacy>> GetPharmacies();
        Task<Pharmacy> GetPharmacy(int id);
        Task<HealthcareWorkers> GetWorker(int id);
        Task<IQueryable<HealthFacilities>> SearchFacilities(string query);
        Task<IQueryable<Medicine>> SearchMedicines(string query);
        Task<IQueryable<Pharmacy>> SearchPharmacies(string query);
        Task<IQueryable<HealthcareWorkers>> SearchWorkers(string query);
        //POST
        Task AddWorker(HealthcareWorkers worker);
        Task AddFacility(HealthFacilities healthFacilities);
        Task AddPharmacy(Pharmacy pharmacy);
        Task AddPharmacyHead(PharmacyHead pharmacyHead);
        Task AddMedicines(Medicine medicine);
        Task AddPandemic(Pandemic pandemic);
    }
}
