﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoData.FarmatikoRepo
{
    public class Repository : IRepository
    {
        private readonly FarmatikoDataContext _context;
        public Repository(FarmatikoDataContext context)
        {
            _context = context;
        }
        //GET
        public async Task<IQueryable<HealthcareWorkers>> GetAllWorkers()
        {
            var Workers = await Task.Run(() => _context.HealthcareWorkers.Take(10));
            return Workers;
        }

        public async Task<IQueryable<HealthFacilities>> GetFacilities()
        {
            var Facilities = await Task.Run(() => _context.HealthFacilities.Take(10));
            return Facilities;
        }

        public async Task<HealthFacilities> GetFacility(int Id)
        {
            var Facility = await _context.HealthFacilities.FindAsync(Id);
            return Facility;
        }

        public async Task<Medicine> GetMedicine(int Id)
        {
            var Medicine = await _context.Medicines.FindAsync(Id);
            return Medicine;
        }

        public async Task<IQueryable<Medicine>> GetMedicines()
        {
            var Medicines = await Task.Run(() => _context.Medicines.Take(10));
            return Medicines;
        }

        public async Task<Pandemic> GetPandemic()
        {
            var Pandemic = await Task.Run(() => _context.Pandemics.FirstOrDefault());
            return Pandemic;
        }

        public async Task<IQueryable<Pharmacy>> GetPharmacies()
        {
            var Pharmacies = await Task.Run(() => _context.Pharmacies.Take(10));
            return Pharmacies;
        }

        public async Task<Pharmacy> GetPharmacy(int id)
        {
            var Pharmacy = await _context.Pharmacies.FindAsync(id);
            return Pharmacy;
        }

        public async Task<HealthcareWorkers> GetWorker(int id)
        {
            var Worker = await _context.HealthcareWorkers.FindAsync(id);
            return Worker;
        }

        public async Task<IQueryable<HealthFacilities>> SearchFacilities(string query)
        {
            var SearchQuery = await Task.Run(() => _context.HealthFacilities
            .Where(x => x.Name.Equals(query))
            .OrderBy(x => x.Name));

            return SearchQuery;
        }

        public async Task<IQueryable<Medicine>> SearchMedicines(string query)
        {
            var SearchQuery = await Task.Run(() => _context.Medicines
            .Where(x => x.Name.Equals(query))
            .OrderBy(x => x.Name));

            return SearchQuery;
        }

        public async Task<IQueryable<Pharmacy>> SearchPharmacies(string query)
        {
            var SearchQuery = await Task.Run(() => _context.Pharmacies
            .Where(x => x.Name.Equals(query))
            .OrderBy(x => x.Name));

            return SearchQuery;
        }

        public async Task<IQueryable<HealthcareWorkers>> SearchWorkers(string query)
        {
            var SearchQuery = await Task.Run(() => _context.HealthcareWorkers
            .Where(x => x.Name.Equals(query))
            .OrderBy(x => x.Name));

            return SearchQuery;
        }

        //POST

        public async Task AddWorker(HealthcareWorkers Worker)
        {
            await Task.Run(() => _context.HealthcareWorkers.Add(Worker));
            await _context.SaveChangesAsync();
        }

        public async Task AddFacility(HealthFacilities healthFacility)
        {
            await Task.Run(() => _context.HealthFacilities.Add(healthFacility));
            await _context.SaveChangesAsync();
        }

        public async Task AddPharmacy(Pharmacy pharmacy)
        {
            await Task.Run(() => _context.Pharmacies.Add(pharmacy));
            await _context.SaveChangesAsync();
        }

        public async Task AddPharmacyHead(PharmacyHead pharmacyHead)
        {
            await Task.Run(() => _context.PharmacyHeads.Add(pharmacyHead));
            await _context.SaveChangesAsync();
        }

        public async Task AddMedicines(Medicine medicine)
        {
            await Task.Run(() => _context.Medicines.Add(medicine));
            await _context.SaveChangesAsync();
        }

        public async Task AddPandemic(Pandemic pandemic)
        {
            await Task.Run(() => _context.Pandemics.Add(pandemic));
            await _context.SaveChangesAsync();
        }
    }
}
