﻿using FarmatikoData.Models;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.FarmatikoServiceInterfaces
{
    public interface IService
    {
        //GET
        Task<IQueryable<HealthcareWorkers>> GetAllWorkers();
        Task<IQueryable<HealthcareWorkers>> SearchWorkers(string query);
        Task<HealthcareWorkers> GetWorker(int id);
        Task<IQueryable<HealthFacilities>> GetFacilities();
        Task<IQueryable<HealthFacilities>> SearchFacilities(string query);
        Task<HealthFacilities> GetFacility(int id);
        Task<Medicine> GetMedicine(int id);
        Task<IQueryable<Medicine>> SearchMedicines(string query);
        Task<IQueryable<Medicine>> GetMedicines();
        Task<Pandemic> GetPandemic();
        Task<IQueryable<Pharmacy>> GetPharmacies();
        Task<IQueryable<Pharmacy>> SearchPharmacies(string query);
        Task<Pharmacy> GetPharmacy(int id);
        //POST
        Task AddWorker(HealthcareWorkers worker);
        Task AddFacility(HealthFacilities healthFacilities);
        Task AddPharmacy(Pharmacy pharmacy);
        Task AddPharmacyHead(PharmacyHead pharmacyHead);
        Task AddMedicines(Medicine medicine);
        Task AddPandemic(Pandemic pandemic);
    }
}
