﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    [ApiController]
    [Route("[controller]/[action]")]
    public class PharmacyController : Controller
    {
        private IPharmacyService _pharmacyService;
        public PharmacyController(IPharmacyService pharmacyService)
        {
            _pharmacyService = pharmacyService;
        }
        [HttpGet]
        public Task<IQueryable<Pharmacy>> Get()
        {
            return _pharmacyService.GetAll();
        }
        [HttpGet]
        public Task<ICollection<Pharmacy>> GetPharmacies()
        {
            return _pharmacyService.GetPharmacies();
        }
        [HttpPost]
        public void UpdatePharmacy(Pharmacy pharmacy)
        {
            _pharmacyService.UpdatePharmacy(pharmacy);
        }
        [HttpPost]
        public void AddPharmacy(Pharmacy pharmacy)
        {
            _pharmacyService.Add(pharmacy);
        }
        [HttpPost]
        public void RemovePharmacy(Pharmacy pharmacy)
        {
            _pharmacyService.Remove(pharmacy);
        }
    }
}
