﻿using System.Linq;
using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    [ApiController]
    [Route("[controller]/[action]")]
    public class PharmacyHeadController : Controller
    {
        private IPharmacyHeadRepository _pharmacyHeadRepository;
        public PharmacyHeadController(IPharmacyHeadRepository pharmacyHeadRepository)
        {
            _pharmacyHeadRepository = pharmacyHeadRepository;
        }
        [HttpGet]
        public IQueryable<PharmacyHead> GetAllPharmacies(string NameOfPharmacy)
        {
            return _pharmacyHeadRepository.GetAllPharmacies(NameOfPharmacy);
        }
        [HttpGet]
        public IQueryable<PharmacyHead> GetPharmacyByName(string Name)
        {
            return _pharmacyHeadRepository.GetPharmacyByName(Name);
        }
        [HttpGet]
        public IQueryable<MedicineList> GetPharmacyMedicines(string NameOfPharmacy)
        {
            return _pharmacyHeadRepository.GetPharmacyMedicines(NameOfPharmacy);
        }
        [HttpPost]
        public void Add(PharmacyHead pharmacyHead)
        {
            _pharmacyHeadRepository.Add(pharmacyHead);
        }
        [HttpPost]
        public void Remove(PharmacyHead pharmacyHead)
        {
            _pharmacyHeadRepository.Remove(pharmacyHead);
        }
    }
}
