﻿using FarmatikoData.FarmatikoRepoInterfaces;
using System.Linq;
using FarmatikoData.Models;

namespace FarmatikoData.FarmatikoRepo
{
    public class HealthFacilityRepository : IHealthFacilityRepository
    {
        private FarmatikoDataContext _context;

        public HealthFacilityRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(HealthFacilities healthFacility)
        {
             _context.HealthFacilities.Add(healthFacility);
            _context.SaveChangesAsync();
        }

        public IQueryable<HealthFacilities> GetAll()
        {
            return _context.HealthFacilities.Take(50).Select(x => new HealthFacilities
            {
                Name = x.Name,
                Municipality = x.Municipality,
                Address = x.Address,
                Type = x.Type,
                Email = x.Email,
                Phone = x.Phone
            }).OrderBy(x => x.Name);
        }

        public IQueryable<HealthFacilities> GetByName(string Name)
        {
            return _context.HealthFacilities.Where(x => x.Name.Equals(Name));
        }

        public void Remove(HealthFacilities healthFacility)
        {
            var facility = _context.HealthFacilities.Where(x => x.Name.Equals(healthFacility.Name)).FirstOrDefault();
            if (facility != null)
            {
                _context.HealthFacilities.Remove(facility);
                _context.SaveChangesAsync();
            }
            
        }
    }
}
