﻿using FarmatikoData;
using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices
{
    public class HealthFacilityService : IHealthFacilityService
    {
        private IHealthFacilityRepository _healthFacilityRepository;

        public HealthFacilityService(IHealthFacilityRepository healthFacilityRepository)
        {
            _healthFacilityRepository = healthFacilityRepository;
        }

        public async void Add(HealthFacilities healthFacility)
        {
            if (healthFacility != null)
                await Task.Run(() => _healthFacilityRepository.Add(healthFacility));
            else throw new Exception("Can't add, health facility is null");
        }

        public async Task<IQueryable<HealthFacilities>> GetAll()
        {
            return await Task.Run(() => _healthFacilityRepository.GetAll());
        }

        public async void Remove(HealthFacilities healthFacility)
        {
            if (healthFacility != null)
                await Task.Run(() => _healthFacilityRepository.Remove(healthFacility));
            else throw new Exception("Can't Remove health facility is null");

        }
    }
}
