﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class HealthcareWorkerService : IHealthcareWorkerService
    {
        private IHealthcareWorkerRepository _healthcareWorkerRepo;
        public HealthcareWorkerService(IHealthcareWorkerRepository healthcareWorkerRepo)
        {
            _healthcareWorkerRepo = healthcareWorkerRepo;
        }
        public async void Add(HealthcareWorkers healthcareWorker)
        {
            if (healthcareWorker != null)
                await Task.Run(() => _healthcareWorkerRepo.Add(healthcareWorker));
            else throw new Exception("Can't add, healthcare worker is null");
        }

        public async Task<IQueryable<HealthcareWorkers>> GetAll()
        {
            var healthCareWorkers = await Task.Run(() => _healthcareWorkerRepo.GetAll());
            if (healthCareWorkers != null)
                return healthCareWorkers;
            return null;
        }

        public async void Remove(HealthcareWorkers healthcareWorker)
        {
            if (healthcareWorker != null)
                await Task.Run(() => _healthcareWorkerRepo.Remove(healthcareWorker));
            else throw new Exception("Can't Remove healthcare worker is null");
        }
    }
}
