﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class PharmacyService : IPharmacyService
    {
        private IPharmacyRepository _pharmacyRepository;
        public PharmacyService(IPharmacyRepository pharmacyRepository)
        {
            _pharmacyRepository = pharmacyRepository;
        }
        public async void Add(Pharmacy pharmacy)
        {
            if (pharmacy != null)
                await Task.Run(() => _pharmacyRepository.Add(pharmacy));
            else throw new Exception("Can't add, pharmacy has null value.");
        }

        public async Task<IQueryable<Pharmacy>> GetAll()
        {
            return await Task.Run(() => _pharmacyRepository.GetAll());
        }

        public async Task<ICollection<Pharmacy>> GetPharmacies()
        {
            return await Task.Run(() => _pharmacyRepository.GetPharmacies());
        }

        public async void Remove(Pharmacy pharmacy)
        {
            if (pharmacy != null)
                await Task.Run(() => _pharmacyRepository.Remove(pharmacy));
            else throw new Exception("Can't remove, pharmacy has null value.");
        }

        public async void UpdatePharmacy(Pharmacy pharmacy)
        {
            if (pharmacy != null)
                await Task.Run(() => _pharmacyRepository.UpdatePharmacy(pharmacy));
            else throw new Exception("Can not update pharmacy, has null value.");
        }
    }
}
