﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class PHService : IPHService
    {
        private readonly IPHRepo _iPHRepo;
        private readonly IRepository _repository;
        public PHService(IPHRepo iPHRepo, IRepository repository)
        {
            _iPHRepo = iPHRepo;
            _repository = repository;
        }

        public async Task<bool> ClaimPharmacy(RequestPharmacyHead pharmacy)
        {
            if (pharmacy != null)
            {
                await _iPHRepo.ClaimPharmacy(pharmacy);
                return true;
            }
            return false;
        }

        public async Task<PharmacyHead> GetPharmacyHeadByIdAsync(int id)
        {
            PharmacyHead Phead = null;
            if (id >= 0)
                Phead = await _iPHRepo.GetPharmacyHeadByIdAsync(id);
            if (Phead != null)
                return Phead;
            throw new Exception("No data found.");
        }

        public async Task<IEnumerable<PharmacyHead>> GetPharmacyHeadInfo()
        {
            var PHeads = await _iPHRepo.GetPharmacyHeadInfo();
            if (PHeads != null)
                return PHeads;
            throw new Exception("No Pharmacy heads found.");
        }

        public async Task<int> Login(PharmacyHead pharmacyHead)
        {
            var PHead = await _iPHRepo.GetPharmacyHeadByIdAsync(pharmacyHead.Id);
            if (PHead.Password.Equals(pharmacyHead.Password))
                return PHead.Id;
            return -1;
        }



        public async Task UpdatePharmacyHead(PharmacyHead pharmacyHead)
        {
            if (pharmacyHead != null)
            {
                var phead = _iPHRepo.GetPharmacyHead(pharmacyHead.Email);

                if (pharmacyHead.PharmaciesList.Count() == 0)
                    pharmacyHead.PharmaciesList = null;


                phead.PHMedicineList = _repository.GetPHMedicines(phead.Email);

                if (phead.MedicineList != pharmacyHead.MedicineList || phead != pharmacyHead)
                {
                    phead.MedicineList = pharmacyHead.MedicineList;
                    List<PharmacyHeadMedicine> list = new List<PharmacyHeadMedicine>();
                    if (pharmacyHead.MedicineList.Count() == 0)
                    {
                        phead.MedicineList = null;
                        int PHMId = phead.PHMedicineList.Select(x => x.Id).Single();
                        int phId = phead.PHMedicineList.Select(x => x.PheadId).Single();
                        int medId = phead.PHMedicineList.Select(x => x.MedicineId).Single();
                        _iPHRepo.DeletePHMedicine(PHMId, phId, medId);
                        return;
                    }
                    foreach (var med in phead.MedicineList)
                    {
                        med.Id++;
                        var PHMObj = phead.PHMedicineList.Select(x => new PharmacyHeadMedicine
                        {
                            PheadId = x.PheadId,
                            Head = x.Head,
                            MedicineId = x.MedicineId,
                            Medicine = x.Medicine
                        }).Where(x => x.MedicineId == med.Id).Single();
                        list.Add(PHMObj);
                    }

                    phead.PHMedicineList = list;

                    await _iPHRepo.UpdatePharmacyHead(phead);
                }
                else throw new Exception("Cannot update pharmacy head since there was no changes.");
            }
            else throw new Exception("PharmacyHead has a null value.");
        }
        public async Task<bool> Add(PharmacyHead pharmacyHead)
        {
            if (pharmacyHead != null)
            {
                await _iPHRepo.Add(pharmacyHead);
                return true;
            }
            return false;
        }

        public async Task<bool> Remove(int id)
        {
            PharmacyHead Phead = await _iPHRepo.GetPharmacyHeadByIdAsync(id);
            if (Phead != null && id >= 0)
            {
                Phead.DeletedOn = DateTime.UtcNow;
                await _iPHRepo.Remove(Phead);
                return true;
            }
            return false;
        }

        public async Task<bool> RemoveClaimingRequest(int id)
        {
            if (id >= 0)
            {
                await _iPHRepo.RemoveClaimingRequest(id);
                return true;
            }
            return false;
        }

        public object GetPharmacyHead(string userName)
        {
            if (userName != null)
            {
                var Phead = _iPHRepo.GetPharmacyHeadByUserName(userName);
                List<PharmacyHeadMedicine> PHMedicines = _iPHRepo.GetPharmacyHeadMedicines(userName);
                List<Medicine> Medicines = _repository.GetMedicines().ToList();
                List<Medicine> PHMedicineList = new List<Medicine>();


                //var meds = PHMedicines.Where(x => x.Id == Phead.Id).ToList();
                var pharmacies = _iPHRepo.GetPharmacies();
                var PheadPharms = pharmacies.Where(x => x.PheadId == Phead.Id).ToList();
                var user = _repository.GetRole(userName);


                if (user.UserRole.ToString().Equals("Admin"))
                {
                    var Admin = new
                    {
                        Id = user.Id,
                        Email = user.Email,
                        Name = user.Name,
                        Passwd = user.Password,
                        MedicineList = PHMedicines,
                        PharmaciesList = Phead.PharmaciesList
                    };

                    return Admin;
                }

                if (PheadPharms.Count() > 0)
                    Phead.MedicineList = PHMedicineList;
                else Phead.PharmaciesList = pharmacies;

                if (Phead.PHMedicineList.Count() > 0)
                {
                    foreach (var med in Medicines)
                    {
                        var PHMObj = Phead.PHMedicineList.Select(x => new PharmacyHeadMedicine
                        {
                            PheadId = x.PheadId,
                            Head = x.Head,
                            MedicineId = x.MedicineId,
                            Medicine = x.Medicine
                        }).Where(x => x.MedicineId == med.Id).SingleOrDefault();
                        if (PHMObj == null || PHMObj == default)
                            break;
                        if (PHMObj.MedicineId == med.Id)
                        {
                            Medicine medicine = new Medicine(med.Name, med.Strength, med.Form, med.WayOfIssuing, med.Manufacturer, med.Price, med.Packaging);
                            PHMedicineList.Add(medicine);
                        }
                    }
                    Phead.MedicineList = PHMedicineList;
                }
                else
                {
                    Phead.MedicineList = Medicines;
                }

                PharmacyHead pharHead = new PharmacyHead()
                {
                    Id = Phead.Id,
                    MedicineList = Phead.MedicineList,
                    PharmaciesList = Phead.PharmaciesList,
                    Email = Phead.Email,
                    Name = Phead.Name,
                    Password = Phead.Password
                };
                return pharHead;
            }
            else throw new Exception("Username is null.");
        }
    }
}
