﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    public class AdminController : Controller
    {
        private readonly IAdminService _adminService;
        private readonly IService _service;
        private readonly IPHService _phservice;
        public AdminController(IAdminService adminService, IService service, IPHService phservice)
        {
            _adminService = adminService;
            _service = service;
            _phservice = phservice;
        }

        //GET
        [HttpGet]
        [Route("api/pharmacyhead")]
        public async Task<IEnumerable<PharmacyHead>> GetPharmacyHeads()
        {
            return await _adminService.GetPharmacyHeads();
        }

        [HttpGet]
        [Route("api/pharmacyhead/requests")]
        public async Task<IEnumerable<RequestPharmacyHead>> GetClaimingRequests()
        {
            return await _adminService.GetClaimingRequests();
        }


        //POST
        [HttpPost]
        [Route("api/pharmacyhead/add")]
        public async Task<IActionResult> AddPharmacyHead(PharmacyHead pharmacyHead)
        {
            await _service.AddPharmacyHead(pharmacyHead);
            return Ok();
        }

        [HttpPost]
        [Route("api/pharmacyhead/delete/{Id}")] 
        public async Task<IActionResult> RemovePharmacyHead([FromQuery]int Id)
        {
            await _service.RemovePharmacyHead(Id);
            return Ok();
        }
        [HttpPost]
        public IActionResult RejectRequset(RequestPharmacyHead req)
        {
            bool Success = _adminService.RejectRequest(req);
            return Ok(Success);
        }
        [HttpPost]
        public async Task<IActionResult> ApproveRequest(PharmacyHead pharmacyHead)
        {
            await _phservice.UpdatePharmacyHead(pharmacyHead);
            return Ok();
        }

    }
}
