﻿using System.Collections.Generic;
using System.Threading.Tasks;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    [ApiController]
    public class FarmatikoController : Controller
    {
        private readonly IService _service;
        public FarmatikoController(IService service)
        {
            _service = service;
        }
        // Workers
        //Get
        [HttpGet]
        [Route("api/workers")]
        public async Task<IEnumerable<HealthcareWorker>> GetWorkers()
        {
            var Workers =  await _service.GetAllWorkers();
            return Workers;
        }
        [HttpGet]
        [Route("api/workers/search/{Query}")]
        public async Task<IEnumerable<HealthcareWorker>> SearchWorkers(string Query)
        {
            return await _service.SearchWorkers(Query);
        }
        [HttpGet]
        [Route("api/workers/{id}")]
        public async Task<HealthcareWorker> GetWorker(int Id)
        {
            return await _service.GetWorker(Id);
        }
        //Post


        //Facilities
        //Get
        [HttpGet]
        [Route("api/facilities")]
        public async Task<IEnumerable<HealthFacility>> GetFacilities()
        {
            return await _service.GetFacilities();
        }
        [HttpGet]
        [Route("api/facilities/search/{Query}")]
        public async Task<IEnumerable<HealthFacility>> SearchFacilities(string Query)
        {
            return await _service.SearchFacilities(Query);
        }
        [HttpGet]
        [Route("api/facilities/{Id}")]
        public async Task<HealthFacility> GetFacility(int Id)
        {
            return await _service.GetFacility(Id);
        }
        //Post

        //Medicine
        //Get
        [HttpGet]
        [Route("api/medicines")]
        public async Task<IEnumerable<Medicine>> GetMedicines()
        {
            return await _service.GetMedicines();
        }
        [HttpGet]
        [Route("api/medicines/search/{Query}")]
        public async Task<IEnumerable<Medicine>> SearchMedicines(string Query)
        {
            return await _service.SearchMedicines(Query);
        }
        [HttpGet]
        [Route("api/medicines/{Id}")]
        public async Task<Medicine> GetMedicine(int Id)
        {
            return await _service.GetMedicine(Id);
        }
        //Pandemic
        [HttpGet]
        [Route("api/pandemic")]
        public async Task<Pandemic> GetPandemic()
        {
            return await _service.GetPandemic();
        }
        //Pharmacy
        //GET
        [HttpGet]
        [Route("api/pharmacy")]
        public async Task<IEnumerable<Pharmacy>> GetPharmacies()
        {
            return await _service.GetPharmacies();
        }
        [HttpGet]
        [Route("api/pharmacy/search/{Query}")]
        public async Task<IEnumerable<Pharmacy>> SearchPharmacies(string Query)
        {
            return await _service.SearchPharmacies(Query);
        }
        [HttpGet]
        [Route("api/pharmacy/{Id}")]
        public async Task<Pharmacy> GetPharmacy(int Id)
        {
            return await _service.GetPharmacy(Id);
        }

    }
}
