﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    [ApiController]
    public class PharmacyHeadController : Controller
    {
        private readonly IPHService _PHService;
        public PharmacyHeadController(IPHService PHService)
        {
            _PHService = PHService;
        }

        //GET
        //Mi trebaat rutite
        [HttpGet]
        [Route("api/pharmacyhead")]
        public async Task<IEnumerable<PharmacyHead>> GetPharmacyHeadInfo(string Token)
        {
            var PHeads = await _PHService.GetPharmacyHeadInfo(Token);
            return PHeads;
        }
        [HttpGet]
        [Route("api/pharmacyhead/{Id}")]
        public async Task<PharmacyHead> GetPharmacyHeadById(int Id)
        {
            var Phead = await _PHService.GetPharmacyHeadByIdAsync(Id);
            return Phead;
        }
        //POST
        [HttpPost]
        [Route("api/pharmacyhead/add")]
        public async Task<IActionResult> AddPharmacyHead(PharmacyHead pharmacyHead)
        {
            bool Success = await _PHService.Add(pharmacyHead);
            return Ok(Success);
        }

        [HttpPost]
        [Route("api/pharmacyhead/login")]
        public async Task<int> Login([FromBody]PharmacyHead pharmacyHead)
        {
            return await _PHService.Login(pharmacyHead);
        }
        [HttpPut]
        [Route("api/pharmacyhead/{Id}")]
        public async Task UpdatePharmacyHead([FromBody]PharmacyHead pharmacyHead)
        {
            await _PHService.UpdatePharmacyHead(pharmacyHead);
        }
        [HttpPost]
        [Route("api/pharmacyhead/requests")]
        public async Task<IActionResult> ClaimPharmacy(RequestPharmacyHead pharmacy)
        {
            bool Success = await _PHService.ClaimPharmacy(pharmacy);
            return Ok(Success);
        }
        [HttpDelete]
        [Route("api/pharmacyhead/delete/{Id}")]
        public async Task<IActionResult> Remove([FromQuery] int Id)
        {
            bool Success = await _PHService.Remove(Id);
            return Ok(Success);
        }
        [HttpPost]
        [Route("api/pharmacyhead/requests/{Id}")]
        public async Task<IActionResult> RemoveClaimingRequest([FromQuery] int Id)
        {
            bool Success = await _PHService.RemoveClaimingRequest(Id);
            return Ok(Success);
        }
        
    }
}
