﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoData.FarmatikoRepo
{
    public class Repository : IRepository
    {
        private readonly FarmatikoDataContext _context;
        public Repository(FarmatikoDataContext context)
        {
            _context = context;
        }
        //GET
        public async Task<IEnumerable<HealthcareWorker>> GetAllWorkers()
        {
            var Workers = await Task.Run(() => _context.HealthcareWorkers.Take(10));
            return Workers;
        }

        public async Task<IEnumerable<HealthFacility>> GetFacilities()
        {
            var Facilities = await Task.Run(() => _context.HealthFacilities.Take(10));
            return Facilities;
        }

        public async Task<HealthFacility> GetFacility(int Id)
        {
            var Facility = await _context.HealthFacilities.FindAsync(Id);
            return Facility;
        }

        public async Task<Medicine> GetMedicine(int Id)
        {
            var Medicine = await _context.Medicines.FindAsync(Id);
            return Medicine;
        }

        public async Task<IEnumerable<Medicine>> GetMedicines()
        {
            var Medicines = await Task.Run(() => _context.Medicines.Take(10));
            return Medicines;
        }

        public async Task<Pandemic> GetPandemic()
        {
            var Pandemic = await Task.Run(() => _context.Pandemics.FirstOrDefault());
            return Pandemic;
        }

        public async Task<IEnumerable<Pharmacy>> GetPharmacies()
        {
            var Pharmacies = await Task.Run(() => _context.Pharmacies.Take(10));
            return Pharmacies;
        }

        public async Task<Pharmacy> GetPharmacy(int id)
        {
            var Pharmacy = await _context.Pharmacies.FindAsync(id);
            return Pharmacy;
        }

        public async Task<HealthcareWorker> GetWorker(int id)
        {
            var Worker = await _context.HealthcareWorkers.FindAsync(id);
            return Worker;
        }

        public async Task<IEnumerable<HealthFacility>> SearchFacilities(string query)
        {
            var SearchQuery = await Task.Run(() => _context.HealthFacilities
            .Where(x => x.Name.Equals(query))
            .OrderBy(x => x.Name));

            return SearchQuery;
        }

        public async Task<IEnumerable<Medicine>> SearchMedicines(string query)
        {
            var SearchQuery = await Task.Run(() => _context.Medicines
            .Where(x => x.Name.Equals(query))
            .OrderBy(x => x.Name));

            return SearchQuery;
        }

        public async Task<IEnumerable<Pharmacy>> SearchPharmacies(string query)
        {
            var SearchQuery = await Task.Run(() => _context.Pharmacies
            .Where(x => x.Name.Equals(query))
            .OrderBy(x => x.Name));

            return SearchQuery;
        }

        public async Task<IEnumerable<HealthcareWorker>> SearchWorkers(string query)
        {
            var SearchQuery = await Task.Run(() => _context.HealthcareWorkers
            .Where(x => x.Name.Equals(query))
            .OrderBy(x => x.Name));

            return SearchQuery;
        }
        public async Task<HealthFacility> GetFacilityJSON(string healthFacility)
        {
            var Facility = await Task.Run(() => _context.HealthFacilities.Where(x => x.Name.Equals(healthFacility)).FirstOrDefault());
            return Facility;
        }

        //POST

        public async Task AddWorker(HealthcareWorker Worker)
        {
            await Task.Run(() => _context.HealthcareWorkers.Add(Worker));
            await _context.SaveChangesAsync();
        }

        public async Task AddFacility(HealthFacility healthFacility)
        {
            await Task.Run(() => _context.HealthFacilities.Add(healthFacility));
            await _context.SaveChangesAsync();
        }

        public async Task AddPharmacy(Pharmacy pharmacy)
        {
            await Task.Run(() => _context.Pharmacies.Add(pharmacy));
            await _context.SaveChangesAsync();
        }

        public async Task AddPharmacyHead(PharmacyHead pharmacyHead)
        {
            await Task.Run(() => _context.PharmacyHeads.Add(pharmacyHead));
            await _context.SaveChangesAsync();
        }

        public async Task AddMedicines(Medicine medicine)
        {
            await Task.Run(() => _context.Medicines.Add(medicine));
            await _context.SaveChangesAsync();
        }

        public async Task AddPandemic(Pandemic pandemic)
        {
            await Task.Run(() => _context.Pandemics.Add(pandemic));
            await _context.SaveChangesAsync();
        }

        public async Task UpdateFacility(HealthFacility healthFacility)
        {
            var Facility = await Task.Run(() => _context.HealthFacilities.Where(x => x.Id == healthFacility.Id).FirstOrDefault());
            Facility.Address = healthFacility.Address;
            Facility.Email = healthFacility.Email;
            Facility.Municipality = healthFacility.Municipality;
            Facility.Name = healthFacility.Name;
            Facility.Phone = healthFacility.Phone;
            Facility.Type = healthFacility.Type;
            await _context.SaveChangesAsync();
        }

        public async Task RemoveMedicine(Medicine medicine)
        {
            await Task.Run(() => _context.Medicines.Remove(medicine));
            await _context.SaveChangesAsync();
        }

        public async Task UpdatePandemic(Pandemic pandemic)
        {
            var Pandemic = await Task.Run(() => _context.Pandemics.Where(x => x.Id == pandemic.Id).FirstOrDefault());
            Pandemic.ActiveGlobal = pandemic.ActiveGlobal;
            Pandemic.ActiveMK = pandemic.ActiveMK;
            Pandemic.DeathsGlobal = pandemic.DeathsGlobal;
            Pandemic.DeathsMK = pandemic.DeathsMK;
            Pandemic.Name = pandemic.Name;
            Pandemic.NewMK = pandemic.NewMK;
            Pandemic.TotalGlobal = pandemic.TotalGlobal;
            Pandemic.TotalMK = pandemic.TotalMK;
            await _context.SaveChangesAsync();
        }

        public async Task RemovePharmacy(Pharmacy pharmacy)
        {
            await Task.Run(() => _context.Pharmacies.Remove(pharmacy));
            await _context.SaveChangesAsync();
        }
        //not impl
        public Task UpdateWorker(HealthcareWorker worker)
        {
            throw new System.NotImplementedException();
        }

        public async Task UpadatePharmacy(Pharmacy pharmacy)
        {
            var Pharmacy = await Task.Run(() => _context.Pharmacies.Where(x => x.Id == pharmacy.Id).FirstOrDefault());
            Pharmacy.Name = pharmacy.Name;
            Pharmacy.Location = pharmacy.Location;
            Pharmacy.WorkAllTime = pharmacy.WorkAllTime;
            Pharmacy.Address = pharmacy.Address;
            await _context.SaveChangesAsync();
        }
        //ke vidime
        public Task UpdateMedicine(Medicine medicine)
        {
            throw new System.NotImplementedException();
        }

        public async Task RemovePharmacyHead(int Id)
        {
            var PHead = await _context.PharmacyHeads.Where(x => x.Id == Id).FirstOrDefaultAsync();
            PHead.DeletedOn = DateTime.UtcNow;
            await _context.SaveChangesAsync();
        }

    }
}
