﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Collections.Generic;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using Microsoft.Extensions.Logging;
using System.Net;
using System.Linq;
using FarmatikoServices.FarmatikoServiceInterfaces;
using RestSharp;
using System.Threading.Tasks;
using OfficeOpenXml;
using System.IO;

namespace FarmatikoServices.Services
{
    public class ProcessJSONService : IProcessJSONService
    {

        private readonly ILogger _logger;
        private readonly IService _service;
        public ProcessJSONService(ILogger logger, IService service)
        {
            _logger = logger;
            _service = service;
        }

        public async Task<Medicine> ReadPharmaciesFromExcel()
        {
            try
            {
                var client = new WebClient();
                string Path = client.DownloadString(@"C:\Users\dslez\Desktop\apteki-fzo.xlsx");
                using (var package = new ExcelPackage(new FileInfo(Path)))
                {
                    var Sheet = package.Workbook.Worksheets[1];
                    for (int i = 2; i < Sheet.Dimension.End.Row; ++i)
                    {
                        Pharmacy pharmacy = new Pharmacy()
                        {
                            Name = Sheet.Cells[i, 2].Value.ToString(),
                            Address = Sheet.Cells[i, 3].Value.ToString(),
                            Location = Sheet.Cells[i, 4].Value.ToString(),
                            WorkAllTime = false
                        };
                        await _service.AddPharmacy(pharmacy);
                    }
                }

            }
            catch(Exception e)
            {
                _logger.LogInformation(e.Message);
                throw new Exception("Cannot process Medicines from Excel.");
            }
            return null;
        }


        public async Task<HealthFacility> GetProcessedHealthFacilitiesFromJSON()
        {
            try
            {
                var client = new WebClient();
                var json = client.DownloadString(@"C:\Users\dslez\Desktop\ustanovi.json");

                var jsonResponse = JObject.Parse(json);
                var records = JArray.Parse(jsonResponse.GetValue("records").ToString());

                foreach (var rec in records)
                {
                    dynamic obj = JsonConvert.DeserializeObject(rec.ToString());
                    var Name = obj[2];
                    var Municipality = obj[6];
                    var Address = obj[9];
                    var Email = obj[10];
                    var Phone = obj[11];
                    var Type = obj[5];
                    HealthFacility healthFacility = new HealthFacility(Name, Municipality, Address, Type, Email, Phone);
                    await Task.Run(() => _service.AddFacility(healthFacility));

                }

            }
            catch (Exception e)
            {
                _logger.LogInformation(e.Message);
                throw new Exception("Cannot process health facilities from JSON.");
            }
            return null;
        }

        public async Task<Pandemic> GetProcessedPandemicsFromJSONApi()
        {
            try
            {
                var client = new RestClient("https://api.covid19api.com/summary");
                var response = client.Execute(new RestRequest());
                string original = response.Content;
                var jsonResponsePandemic = JObject.Parse(original);
                var global = JObject.Parse(jsonResponsePandemic.GetValue("Global").ToString());
                var TotalConfirmed = long.Parse(global.GetValue("TotalConfirmed").ToString());
                var TotalDeaths = long.Parse(global.GetValue("TotalDeaths").ToString());
                var TotalRecovered = long.Parse(global.GetValue("TotalRecovered").ToString());

                var mk = JArray.Parse(jsonResponsePandemic.GetValue("Countries").ToString());
                dynamic objP = mk[100];
                var TotalMk = Int32.Parse(objP.GetValue("TotalConfirmed").ToString());
                var TotalDeathsMK = Int32.Parse(objP.GetValue("TotalDeaths").ToString());
                var TotalRecoveredMK = Int32.Parse(objP.GetValue("TotalRecovered").ToString());
                var NewMK = Int32.Parse(objP.GetValue("NewConfirmed").ToString());

                var Name = "Coronavirus";
                var ActiveMk = TotalMk - (TotalRecoveredMK + TotalDeathsMK);
                var ActiveGlobal = TotalConfirmed - (TotalRecovered + TotalDeaths);

                Pandemic pandemic = new Pandemic(Name, TotalMk, ActiveMk, TotalDeathsMK, NewMK, TotalConfirmed, TotalDeaths, ActiveGlobal);
                await Task.Run(() => _service.AddPandemic(pandemic));
            }
            catch (Exception e)
            {
                _logger.LogInformation(e.Message);
            }
            return null;
        }

        public async Task<HealthcareWorker> GetProcessedHealthcareWorkersFromJSON()
        {
            try
            {
                var client = new WebClient();
                var jsonW = client.DownloadString(@"C:\Users\dslez\Desktop\rabotnici.json");

                var jsonResponseW = JObject.Parse(jsonW);
                var recordsW = JArray.Parse(jsonResponseW.GetValue("records").ToString());

                foreach (var rec in recordsW)
                {
                    dynamic obj = JsonConvert.DeserializeObject(rec.ToString());
                    var Name = obj[4];
                    var Branch = obj[2];
                    var FacilityName = obj[1];
                    var Title = obj[3];
                    HealthFacility facility = await _service.GetFacilityJSON(FacilityName);
                    HealthFacility Facility = new HealthFacility(facility.Name, facility.Municipality, facility.Address,
                                                                        facility.Type, facility.Email, facility.Phone);
                    HealthcareWorker healthcareWorker = new HealthcareWorker(Name, Branch, Facility, Title);
                    /*Facility.Name = obj[1];
                    Facility.Municipality = "WorkerFacilityMunicipality";
                    Facility.Address = "WorkerFacilityAddress";*/
                    /*healthcareWorker.Name = Name;
                    healthcareWorker.Branch = Branch;
                    healthcareWorker.Facility = Facility;
                    healthcareWorker.Title = Title;*/
                    await Task.Run(() => _service.AddWorker(healthcareWorker));
                }
            }
            catch (Exception e)
            {
                _logger.LogInformation(e.Message);
            }
            return null;
        }

        public async Task<Medicine> GetProcessedMedicinesFromJSON()
        {
            try
            {
                var client = new WebClient();
                var jsonM = client.DownloadString(@"C:\Users\dslez\Desktop\lekovi.json");

                var jsonResponseM = JObject.Parse(jsonM);
                var recordsM = JArray.Parse(jsonResponseM.GetValue("records").ToString());

                foreach (var rec in recordsM)
                {
                    dynamic obj = JsonConvert.DeserializeObject(rec.ToString());
                    var Name = obj[1];
                    var Strength = obj[7];
                    var Form = obj[6];
                    var WayOfIssuing = obj[9];
                    var Manufacturer = obj[11];
                    var Price = float.Parse(obj[17]);
                    var Packaging = obj[8];
                    Medicine medicine = new Medicine(Name, Strength, Form, WayOfIssuing, Manufacturer, Price, Packaging);
                    /*medicine.Name = Name;
                    medicine.Strength = Strength;
                    medicine.Form = Form;
                    medicine.WayOfIssuing = WayOfIssuing;
                    medicine.Manufacturer = Manufacturer;
                    medicine.Price = Price;
                    medicine.Packaging = Packaging;*/
                    await Task.Run(() => _service.AddMedicines(medicine));
                }
            }
            catch (Exception e)
            {
                _logger.LogInformation(e.Message);
            }
            return null;
        }
    }
}
