import { Component, OnInit } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { Router, ActivatedRoute } from '@angular/router';
import { first } from 'rxjs/operators';
import { AuthService } from '../shared/auth.service';

@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.css']
})
export class LoginComponent implements OnInit {
  loginForm: FormGroup;
  email: string;
  passwd: string;
  errorMessage: string;

  constructor(private authService: AuthService,private router: Router, private route: ActivatedRoute) {
    this.loginForm = new FormGroup({
      email: new FormControl('', [Validators.required, Validators.email]),
      password: new FormControl('', [Validators.required])
    });
  }

  ngOnInit(): void {
  }

  loginPharmacyHead() {
    this.authService.login(this.email,this.passwd)
        .pipe(first())
        .subscribe((data) => {
            if(data) {
              this.router.navigate(['/dashboard']);
            }},
            (err: any) => {
                this.errorMessage = err.toString();
            });
    this.loginForm.reset();
  }
}
