import { Injectable } from '@angular/core';
import { Router } from '@angular/router';
import { HttpClient, HttpErrorResponse } from '@angular/common/http';
import { BehaviorSubject, Observable } from 'rxjs';
import { catchError, map } from 'rxjs/operators';
import { IPharmacyHead } from './interfaces';
import { DataService } from './data.service';


@Injectable({
  providedIn: 'root'
})
export class AuthService {
  private headSubject: BehaviorSubject<IPharmacyHead>;
  public head: Observable<IPharmacyHead>;
  basePharmacyHead: string = '/api/pharmacyhead';

  constructor(private router: Router, private http: HttpClient, private dataService: DataService) {
    this.headSubject = new BehaviorSubject<IPharmacyHead>(JSON.parse(localStorage.getItem('head')));
    this.head = this.headSubject.asObservable();
  }

  public get headValue(): IPharmacyHead {
    return this.headSubject.value;
  }

  login(email: string, passwd: string) : Observable<any> {
    let postData = {email : email ,password : passwd};
    return this.http.post<any>(this.basePharmacyHead + '/login', postData)
                .pipe(
                    map((data) => {
                        localStorage.setItem('head', JSON.stringify(data));
                        this.headSubject.next(data);
                        return data;
                    }),
                    catchError(this.handleError)
                );
  }

  logout() {
      localStorage.removeItem('user');
      this.headSubject.next(null);
      this.router.navigate(['/login']);
  }

  private handleError(error: HttpErrorResponse) {
    console.error('server error:', error);
    if (error.error instanceof Error) {
      let errMessage = error.error.message;
      return Observable.throw(errMessage);
    }
    return Observable.throw(error || 'ASP.NET Core server error');
  }
}
