﻿using System.Collections.Generic;
using System.Linq;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using Microsoft.AspNetCore.Mvc;

namespace Farmatiko.Controllers
{
    [ApiController]
    [Route("[controller]/[action]")]
    public class PharmacyController : Controller
    {
        private IPharmacyService _pharmacyService;
        public PharmacyController(IPharmacyService pharmacyService)
        {
            _pharmacyService = pharmacyService;
        }
        [HttpGet]
        public IQueryable<Pharmacy> Get()
        {
            return _pharmacyService.GetAll();
        }
        [HttpGet]
        public ICollection<Pharmacy> GetPharmacies()
        {
            return _pharmacyService.GetPharmacies();
        }
        [HttpPost]
        public void UpdatePharmacy(Pharmacy pharmacy, string Name)
        {
            _pharmacyService.UpdatePharmacy(pharmacy,Name);
        }
        [HttpPost]
        public void AddPharmacy(Pharmacy pharmacy)
        {
            _pharmacyService.Add(pharmacy);
        }
        [HttpPost]
        public void RemovePharmacy(Pharmacy pharmacy)
        {
            _pharmacyService.Remove(pharmacy);
        }
    }
}
