﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class PandemicRepository : IPandemicRepository
    {
        private FarmatikoDataContext _context;

        public PandemicRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(Pandemic pandemic)
        {
            _context.Pandemics.Add(pandemic);
            _context.SaveChangesAsync();
        }

        public IQueryable<Pandemic> GetAll()
        {
            return _context.Pandemics.OrderBy(x => x.Name);
        }

        public void Remove(Pandemic pandemic)
        {
            _context.Pandemics.Remove(pandemic);
            _context.SaveChangesAsync();
        }
    }
}
