﻿using FarmatikoData.FarmatikoRepo;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;

namespace FarmatikoServices.Services
{
    public class MedicineListService : IMedicineListService
    {
        private IMedicineListRepository _medicineListRepository;
        public MedicineListService(IMedicineListRepository medicineListRepository)
        {
            _medicineListRepository = medicineListRepository;
        }

        public void Add(MedicineList medicineList)
        {
            try
            {
                if (medicineList != null)
                    _medicineListRepository.Add(medicineList);
            }
            catch (Exception e)
            {
                e = new Exception("Can't add the medicine list is null.");
                throw e;
            }
        }

        public IQueryable<MedicineList> GetAll()
        {
            return _medicineListRepository.GetAll();
        }

        public ICollection<MedicineList> GetByManufacturer(string Manufacturer)
        {
            try
            {
                if (Manufacturer != null)
                {

                    return _medicineListRepository.GetByManufacturer(Manufacturer);
                }
            }
            catch (Exception e)
            {
                e = new Exception("Can't get name of manufacturer is null");
                throw e;
            }
            return null;
        }

        public ICollection<MedicineList> GetByName(string Name)
        {
            try
            {
                if (Name != null)
                {
                    return _medicineListRepository.GetByName(Name);
                }
            }
            catch (Exception e)
            {
                e = new Exception("Can't get name is null");
                throw e;
            }
            return null;
        }

        public void Remove(MedicineList medicineList)
        {
            try
            {
                if (medicineList != null)
                    _medicineListRepository.Remove(medicineList);
            }
            catch (Exception e)
            {
                e = new Exception("Can't remove the medicine list is null.");
                throw e;
            }
        }
    }
}
