﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;

namespace FarmatikoServices.Services
{
    public class MedicineService : IMedicineService
    {
        private IMedicineRepository _medicineRepository;
        public MedicineService(IMedicineRepository medicineRepository)
        {
            _medicineRepository = medicineRepository;
        }

        public void Add(Medicine medicine)
        {
            try
            {
                if (medicine != null)
                    _medicineRepository.Add(medicine);
            } 
            catch (Exception e) 
            {
                e = new Exception("Can't Add medicine is null");
                throw e;
            }
        }

        public IQueryable<Medicine> GetAll()
        {
            return _medicineRepository.GetAll();
        }

        public IQueryable<Medicine> GetByManufacturer(string Manufacturer)
        {
            try
            {
                if (Manufacturer != null)
                    return _medicineRepository.GetByManufacturer(Manufacturer);
            }
            catch (Exception e)
            {
                e = new Exception("Can't get, name of manufacturer is null");
                throw e;
            }
            
            return null;
        }

        public IQueryable<Medicine> GetByName(string Name)
        {
            try
            {
                if (Name != null)
                    return _medicineRepository.GetByName(Name);
            }
            catch (Exception e)
            {
                e = new Exception("Can't get, name is null");
            }
            
            return null;
        }

        public void Remove(string Medicine)
        {
            try
            {
                if (Medicine != null)
                    _medicineRepository.Remove(Medicine);
            }
            catch (Exception e)
            {
                e = new Exception("Can't Add medicine is null");
                throw e;
            }
        }
    }
}
