﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class HealthcareWorkerRepository : IHealthcareWorkerRepository
    {

        private FarmatikoDataContext _context;

        public HealthcareWorkerRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(HealthcareWorkers HealthcareWorker)
        {
            _context.HealthcareWorkers.Add(HealthcareWorker);
            _context.SaveChangesAsync();
        }

        public IQueryable<HealthcareWorkers> GetAll()
        {
            return _context.HealthcareWorkers.OrderBy(x => x.Name);
        }

        public void Remove(HealthcareWorkers healthcareWorker)
        {
            var healthCareWorker = _context.HealthcareWorkers.Where(x => x.Name.Equals(healthcareWorker.Name));
            _context.HealthcareWorkers.Remove((HealthcareWorkers)healthCareWorker);
        }
    }
}
