﻿using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineListRepository : IMedicineListRepository
    {
        private FarmatikoDataContext _context;
        public MedicineListRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(MedicineList medicineList)
        {
            _context.MedicineLists.Add(medicineList);
            _context.SaveChangesAsync();
        }
        /*public MedicineList CheckMedicine(string Name)
        {
            return (MedicineList)_context.MedicineLists
                .Where(medicineList => medicineList.Medicine.Name.Contains(Name))
                .OrderBy(x => x.Medicine.Name)
                .Include(x => x.HasMedicine)
                .Cast<MedicineList>();
        }*/
         
        public IQueryable<MedicineList> GetAll()
        {
            return _context.MedicineLists.OrderBy(x => x.Medicine.Name);
        }

        public ICollection<MedicineList> GetByManufacturer(string Manufacturer)
        {
            return (ICollection<MedicineList>)_context.MedicineLists
                .Where(x => x.Medicine.Manufacturer.Contains(Manufacturer))
                .OrderBy(x => x.Medicine.Name)
                .Cast<ICollection<MedicineList>>();
        }
        public ICollection<MedicineList> GetByName(string Name)
        {
            return (ICollection<MedicineList>)_context.MedicineLists
                .Where(x => x.Medicine.Name.Contains(Name))
                .OrderBy(x => x.Medicine.Name)
                .Cast<ICollection<MedicineList>>();
        }

        public void Remove(MedicineList medicineList)
        {
            var list = (MedicineList)_context.MedicineLists.Where(x => x.Medicine.Equals(medicineList.Medicine));
            _context.MedicineLists.Remove(list);
        }
    }
}
