﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineRepository : IMedicineRepository
    {
        private FarmatikoDataContext _context;
        public MedicineRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(Medicine Medicine)
        {
            _context.Medicines.Add(Medicine);
            _context.SaveChangesAsync();
        }

        public IQueryable<Medicine> GetAll()
        {
            return _context.Medicines.OrderBy(x => x.Name);
        }

        public IQueryable<Medicine> GetByManufacturer(string Manufacturer)
        {
            return _context.Medicines.Where(x => x.Name.Contains(Manufacturer)).OrderBy(x => x.Manufacturer);
        }

        public IQueryable<Medicine> GetByName(string Name)
        {
            return _context.Medicines.Where(medicine => medicine.Name.Contains(Name)).OrderBy(x => x.Name);
        }

        public void Remove(string medicine)
        {
            Medicine med = (Medicine)_context.Medicines.Where(medicine => medicine.Name.Equals(medicine));
            _context.Medicines.Remove(med);
        }
    }
}
