﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class PharmacyHeadRepository : IPharmacyHeadRepository
    {
        private FarmatikoDataContext _context;

        public PharmacyHeadRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(PharmacyHead pharmacyHead)
        {
            _context.PharmacyHeads.Add(pharmacyHead);
            _context.SaveChangesAsync();
        }

        public IQueryable<PharmacyHead> GetAllPharmacies(string NameOfPharmacyHeads)
        {
            return _context.PharmacyHeads
                .Where(pharmacyHead => pharmacyHead.Name.Contains(NameOfPharmacyHeads))
                .OrderBy(x => x.Name);
        }
        //Not needed
        public IQueryable<PharmacyHead> GetPharmacyByName(string Name)
        {
            return _context.PharmacyHeads.Where(pharmacyHead => pharmacyHead.Name.Equals(Name));
        }

        public IQueryable<MedicineList> GetPharmacyMedicines(string NameOfPharmacy)
        {

            IQueryable<MedicineList> Pharmacy = (IQueryable<MedicineList>)_context.PharmacyHeads.Where(x => x.Name.Equals(NameOfPharmacy));
            
            return Pharmacy;
        }

        public void Remove(PharmacyHead pharmacyHead, string Name)
        {
            var phead = (PharmacyHead)_context.PharmacyHeads.Where(phead => phead.Name.Equals(Name)).FirstOrDefault();
            _context.PharmacyHeads.Remove(phead);
            _context.SaveChangesAsync();
        }
    }
}
