﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Linq;

namespace FarmatikoServices.Services
{
    public class HealthcareWorkerService : IHealthcareWorkerService
    {
        private IHealthcareWorkerRepository _healthcareWorkerRepo;
        public HealthcareWorkerService(IHealthcareWorkerRepository healthcareWorkerRepo)
        {
            _healthcareWorkerRepo = healthcareWorkerRepo;
        }
        public void Add(HealthcareWorkers healthcareWorker)
        {
            try
            {
                if (healthcareWorker != null)
                    _healthcareWorkerRepo.Add(healthcareWorker);
            }
            catch (Exception e)
            {
                e = new Exception("Can't Add healthcare worker is null");
                throw e;
            }
        }

        public IQueryable<HealthcareWorkers> GetAll()
        {
            return _healthcareWorkerRepo.GetAll();
        }

        public void Remove(HealthcareWorkers healthcareWorker)
        {
            try
            {
                if (healthcareWorker != null)
                    _healthcareWorkerRepo.Remove(healthcareWorker);
            }
            catch (Exception e)
            {
                e = new Exception("Can't Remove healthcare worker is null");
                throw e;
            }
        }
    }
}
