﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Linq;

namespace FarmatikoServices.Services
{
    public class PandemicService : IPandemicService
    {
        private IPandemicRepository _pandemicRepository;
        public PandemicService(IPandemicRepository pandemicRepository)
        {
            _pandemicRepository = pandemicRepository;
        }

        public void Add(Pandemic pandemic)
        {
            try
            {
                if (pandemic != null)
                {
                    _pandemicRepository.Add(pandemic);
                }
            }
            catch (Exception e)
            {
                e = new Exception("Can't add pandemic is null.");
                throw e;
            }
        }

        public IQueryable<Pandemic> GetAll()
        {
            return _pandemicRepository.GetAll();
        }

        public void Remove(Pandemic pandemic)
        {
            try
            {
                if (pandemic != null)
                    _pandemicRepository.Remove(pandemic);
            }
            catch (Exception e)
            {
                e = new Exception("Can't remove, pandemic is null.");
            }
        }
    }
}
