﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;

namespace FarmatikoServices.Services
{
    public class PharmacyService : IPharmacyService
    {
        private IPharmacyRepository _pharmacyRepository;
        public PharmacyService(IPharmacyRepository pharmacyRepository)
        {
            _pharmacyRepository = pharmacyRepository;
        }
        public void Add(Pharmacy pharmacy)
        {
            try
            {
                if (pharmacy != null)
                {
                    _pharmacyRepository.Add(pharmacy);
                }
            }
            catch (Exception e)
            {
                e = new Exception("Can't add, pharmacy has null value.");
                throw e;
            }
            
        }

        public IQueryable<Pharmacy> GetAll()
        {
            return _pharmacyRepository.GetAll();
        }

        public ICollection<Pharmacy> GetPharmacies()
        {
            return _pharmacyRepository.GetPharmacies();
        }

        public void Remove(Pharmacy pharmacy)
        {
            try
            {
                if (pharmacy != null)
                    _pharmacyRepository.Remove(pharmacy);
            }
            catch (Exception e)
            {
                e = new Exception("Can't remove, pharmacy has null value.");
                throw e;
            }
        }

        public void UpdatePharmacy(Pharmacy pharmacy, string Name)
        {
            try
            {
                if (pharmacy != null && Name != null)
                {
                    _pharmacyRepository.UpdatePharmacy(pharmacy, Name);
                }
            }
            catch (Exception e)
            {
                e = new Exception("Can not update pharmacy, has null value.");
                throw e;
            }
            
        }
    }
}
