﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Collections.Generic;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using Microsoft.Extensions.Logging;
using System.Net;
using System.Linq;
using FarmatikoServices.FarmatikoServiceInterfaces;
using RestSharp;

namespace FarmatikoServices.Services
{
    public class ProcessJSONService : IProcessJSONService
    {
        private IHealthFacilityRepository _healthFacilityRepository;
        //private readonly ILogger _logger;
        public ProcessJSONService(IHealthFacilityRepository healthFacilityRepository)
        {
            //_logger = logger;
            _healthFacilityRepository = healthFacilityRepository;
        }
        
        public List<HealthFacilities> GetProcessedHealthFacilitiesFromJSON()
        {
            try
            {
                var client = new WebClient();
                var json = client.DownloadString(@"C:\Users\dslez\Desktop\ustanovi.json");

                var jsonResponse = JObject.Parse(json);
                var records = JArray.Parse(jsonResponse.GetValue("records").ToString());


                foreach(var rec in records)
                {
                    dynamic obj = JsonConvert.DeserializeObject(rec.ToString());
                    var Name = obj[2];
                    var Municipality = obj[6];
                    var Address = obj[9];
                    var Email = obj[10];
                    var Phone = obj[11];
                    var Type = obj[5];
                    HealthFacilities healthFacility = new HealthFacilities();
                    healthFacility.Name = Name;
                    healthFacility.Municipality = Municipality;
                    healthFacility.Address = Address;
                    healthFacility.Email = Email;
                    healthFacility.Phone = Phone;
                    healthFacility.Type = Type;
                    var obje = healthFacility;
                    _healthFacilityRepository.Add(healthFacility);
                    
                }



                /*var client1 = new RestClient("https://api.covid19api.com/summary");
                var response = client1.Execute(new RestRequest());
                string original = response.Content;
                var jsonResponse = JObject.Parse(original);
                var global = JObject.Parse(jsonResponse.GetValue("Global").ToString());
                var total = Int32.Parse(global.GetValue("TotalConfirmed").ToString());
                Pandemic pandemic = new Pandemic();
                pandemic.TotalGlobal = total;*/

            }
            catch (Exception e)
            {
                //_logger.LogError(e.Message);
                Console.WriteLine(e.Message);
                throw e;
                return null;
            }
            return null;
        }

    }
}
