import { Component, OnInit, ViewChild, Inject, Input } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { HealthFacilities } from '../models/HealthFacilities';
import { MatTableDataSource } from '@angular/material/table';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { HealthcareWorkers } from '../models/HealthcareWorkers';

@Component({
  selector: 'app-counter-component',
  templateUrl: './counter.component.html',
  styleUrls: ['./counter.component.css']
})
export class CounterComponent implements OnInit {
  @Input() facilities: HealthFacilities[];
  public workers: HealthcareWorkers[];
  displayedColumns = ['id','createdOn','deletedOn','Име','Општина','Адреса', 'Тип', 'Е-пошта', 'Телефон'];
  displayedColumnsWorkers = ['Име','Гранка','Установа', 'Назив'];
  dataSource = new MatTableDataSource<HealthFacilities>();
  dataSourceWorkers = new MatTableDataSource<HealthcareWorkers>();

  @ViewChild(MatPaginator, {static: false}) paginator: MatPaginator;
  @ViewChild(MatSort) sort: MatSort;

  constructor(http: HttpClient, @Inject('BASE_URL') baseUrl: string) {
    http.get<HealthFacilities[]>(baseUrl + 'HealthFacilities/Get?').subscribe(result => {
      this.facilities = result;
      console.log(this.facilities);
      this.dataSource = new MatTableDataSource<HealthFacilities>(this.facilities);
    }, error => console.error(error));
    http.get<HealthcareWorkers[]>(baseUrl + 'HealthcareWorker/Get?').subscribe(result => {
      this.workers = result;
      console.log(this.workers);
      this.dataSourceWorkers = new MatTableDataSource<HealthcareWorkers>(this.workers);
    }, error => console.error(error));
  }
  ngOnInit(): void {
  }

  ngAfterViewInit(): void {
    this.dataSource.paginator = this.paginator;
    this.dataSource.sort = this.sort;
  }

  applyFilter(filterValue: string) {
    filterValue = filterValue.trim();
    filterValue = filterValue.toLowerCase();
    this.dataSource.filter = filterValue;
  }

  applyFilterWorkers(filterValue: string) {
    filterValue = filterValue.trim();
    filterValue = filterValue.toLowerCase();
    this.dataSourceWorkers.filter = filterValue;
  }
}
