﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoData.FarmatikoRepo
{
    public class HealthcareWorkerRepository : IHealthcareWorkerRepository
    {

        private FarmatikoDataContext _context;

        public HealthcareWorkerRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(HealthcareWorkers HealthcareWorker)
        {
            _context.HealthcareWorkers.Add(HealthcareWorker);
            _context.SaveChangesAsync();
        }

        public IQueryable<HealthcareWorkers> GetAll()
        {
            return _context.HealthcareWorkers.Take(50).Select(x => new HealthcareWorkers
            { 
                Name = x.Name,
                Branch = x.Branch,
                Facility = x.Facility,
                Title = x.Title
            }).OrderBy(x => x.Name);
        }

        public void Remove(HealthcareWorkers healthcareWorker)
        {
            var healthCareWorker = _context.HealthcareWorkers.Where(x => x.Name.Equals(healthcareWorker.Name)).FirstOrDefault();
            if (healthCareWorker != null)
            {
                _context.HealthcareWorkers.Remove(healthCareWorker);
                _context.SaveChangesAsync();
            }
            
        }
    }
}
