﻿using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class MedicineListRepository : IMedicineListRepository
    {
        private FarmatikoDataContext _context;
        public MedicineListRepository(FarmatikoDataContext context)
        {
            _context = context;
        }
        public void Add(MedicineList medicineList)
        {
            _context.MedicineLists.Add(medicineList);
            _context.SaveChangesAsync();
        }
        /*public MedicineList CheckMedicine(string Name)
        {
            return (MedicineList)_context.MedicineLists
                .Where(medicineList => medicineList.Medicine.Name.Contains(Name))
                .OrderBy(x => x.Medicine.Name)
                .Include(x => x.HasMedicine)
                .Cast<MedicineList>();
        }*/
         
        public IQueryable<MedicineList> GetAll()
        {
            return _context.MedicineLists.Take(50).Select(x => new MedicineList 
            { 
                Medicine = x.Medicine,
                HasMedicine = x.HasMedicine 
            }).OrderBy(x => x.Medicine.Name);
        }

        public ICollection<MedicineList> GetByManufacturer(string Manufacturer)
        {
            return (ICollection<MedicineList>)_context.MedicineLists.Take(50)
                .Where(x => x.Medicine.Manufacturer.Contains(Manufacturer))
                .Select(x => new MedicineList
                {
                    Medicine = x.Medicine,
                    HasMedicine = x.HasMedicine
                })
                .OrderBy(x => x.Medicine.Name)
                .Cast<ICollection<MedicineList>>();
        }
        public ICollection<MedicineList> GetByName(string Name)
        {
            return (ICollection<MedicineList>)_context.MedicineLists.Take(50)
                .Where(x => x.Medicine.Name.Contains(Name))
                .Select(x => new MedicineList
                {
                    Medicine = x.Medicine,
                    HasMedicine = x.HasMedicine
                })
                .OrderBy(x => x.Medicine.Name)
                .Cast<ICollection<MedicineList>>();
        }

        public void Remove(MedicineList medicineList)
        {
            var list = _context.MedicineLists.Where(x => x.Medicine.Equals(medicineList.Medicine)).FirstOrDefault();
            if (list != null)
            {
                _context.MedicineLists.Remove(list);
                _context.SaveChangesAsync();
            }
        }
    }
}
