﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Linq;

namespace FarmatikoData.FarmatikoRepo
{
    public class PharmacyHeadRepository : IPharmacyHeadRepository
    {
        private FarmatikoDataContext _context;

        public PharmacyHeadRepository(FarmatikoDataContext context)
        {
            _context = context;
        }

        public void Add(PharmacyHead pharmacyHead)
        {
            _context.PharmacyHeads.Add(pharmacyHead);
            _context.SaveChangesAsync();
        }

        public IQueryable<PharmacyHead> GetAllPharmacies(string NameOfPharmacyHeads)
        {
            return _context.PharmacyHeads.Where(pharmacyHead => pharmacyHead.Name.Contains(NameOfPharmacyHeads))
                .Take(10).Select(x => new PharmacyHead
                {
                    MedicineLists = x.MedicineLists,
                    PharmaciesList = x.PharmaciesList,
                    Email = x.Email,
                    Name = x.Name,
                }).OrderBy(x => x.Name);
        }
        //Not needed
        public IQueryable<PharmacyHead> GetPharmacyByName(string Name)
        {
            return _context.PharmacyHeads.Take(10)
                .Where(pharmacyHead => pharmacyHead.Name.Equals(Name))
                .Select(x => new PharmacyHead
                {
                    MedicineLists = x.MedicineLists,
                    PharmaciesList = x.PharmaciesList,
                    Email = x.Email,
                    Name = x.Name,
                }).OrderBy(x => x.Name);
        }

        public IQueryable<MedicineList> GetPharmacyMedicines(string NameOfPharmacy)
        {

            IQueryable<MedicineList> Pharmacy = (IQueryable<MedicineList>)_context.PharmacyHeads
                .Take(50)
                .Where(x => x.Name.Equals(NameOfPharmacy))
                .Select(x => new PharmacyHead
                {
                    MedicineLists = x.MedicineLists
                }).OrderBy(x => x.Name);

            return Pharmacy;
        }

        public void Remove(PharmacyHead pharmacyHead)
        {
            var phead = _context.PharmacyHeads.Where(phead => phead.Name.Equals(pharmacyHead.Name)).FirstOrDefault();
            if (phead != null)
            {
                _context.PharmacyHeads.Remove(phead);
                _context.SaveChangesAsync();
            }
        }
    }
}
