﻿using FarmatikoData.FarmatikoRepo;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class MedicineListService : IMedicineListService
    {
        private IMedicineListRepository _medicineListRepository;
        public MedicineListService(IMedicineListRepository medicineListRepository)
        {
            _medicineListRepository = medicineListRepository;
        }

        public async void Add(MedicineList medicineList)
        {
            if (medicineList != null)
                await Task.Run(() => _medicineListRepository.Add(medicineList));
            else throw new Exception("Can't add, the medicine list is null.");
        }

        public async Task<IQueryable<MedicineList>> GetAll()
        {
            return await Task.Run(() => _medicineListRepository.GetAll());
        }

        public async Task<ICollection<MedicineList>> GetByManufacturer(string Manufacturer)
        {
            if (Manufacturer != null)
                return await Task.Run(() => _medicineListRepository.GetByManufacturer(Manufacturer));
            else throw new Exception("Can't get, name of manufacturer is null");
        }

        public async Task<ICollection<MedicineList>> GetByName(string Name)
        {
            if (Name != null)
                return await Task.Run(() => _medicineListRepository.GetByName(Name));
            else throw new Exception("Can't get, name is null");
        }

        public async void Remove(MedicineList medicineList)
        {
            if (medicineList != null)
                await Task.Run(() => _medicineListRepository.Remove(medicineList));
            else throw new Exception("Can't remove, the medicine list is null.");
        }
    }
}
