﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class MedicineService : IMedicineService
    {
        private IMedicineRepository _medicineRepository;
        public MedicineService(IMedicineRepository medicineRepository)
        {
            _medicineRepository = medicineRepository;
        }

        public async void Add(Medicine medicine)
        {
            if (medicine != null)
                await Task.Run(() => _medicineRepository.Add(medicine));
            else throw new Exception("Can't Add medicine is null");
        }

        public async Task<IQueryable<Medicine>> GetAll()
        {
            return await Task.Run(() => _medicineRepository.GetAll());
        }

        public async Task<IQueryable<Medicine>> GetByManufacturer(string Manufacturer)
        {
            if (Manufacturer != null)
                return await Task.Run(() => _medicineRepository.GetByManufacturer(Manufacturer));
            else throw new Exception("Can't get, name of manufacturer is null");
        }

        public async Task<IQueryable<Medicine>> GetByName(string Name)
        {
            if (Name != null)
                return await Task.Run(() => _medicineRepository.GetByName(Name));
            else throw new Exception("Can't get, name is null");
        }

        public async void Remove(Medicine Medicine)
        {
            if (Medicine != null)
                await Task.Run(() => _medicineRepository.Remove(Medicine));
            else throw new Exception("Can't Add medicine is null");
        }
    }
}
