﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using FarmatikoServices.FarmatikoServiceInterfaces;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class PharmacyHeadService : IPharmacyHeadService
    {
        private IPharmacyHeadRepository _pharmacyHeadRepository;
        public PharmacyHeadService(IPharmacyHeadRepository pharmacyHeadRepository)
        {
            _pharmacyHeadRepository = pharmacyHeadRepository;
        }

        public async void Add(PharmacyHead pharmacyHead)
        {
            if (pharmacyHead != null)
                await Task.Run(() => _pharmacyHeadRepository.Add(pharmacyHead));
            else throw new Exception("Can't add, pharmacy head is null.");
        }

        public async Task<IQueryable<PharmacyHead>> GetAllPharmacies(string NameOfPharmacyHead)
        {
            if (NameOfPharmacyHead != null)
            {
                IQueryable<PharmacyHead> pharmacies = await Task.Run(() => _pharmacyHeadRepository.GetAllPharmacies(NameOfPharmacyHead));
                if (pharmacies != null)
                    return pharmacies;
            }
            return null;
        }

        public async Task<IQueryable<PharmacyHead>> GetPharmacyByName(string Name)
        {
            if (Name != null)
            {
                IQueryable<PharmacyHead> PharmacyHead = await Task.Run(() => _pharmacyHeadRepository.GetPharmacyByName(Name));
                if (PharmacyHead != null)
                    return PharmacyHead;
            }
            return null;
        }

        public async Task<IQueryable<MedicineList>> GetPharmacyMedicines(string NameOfPharmacy)
        {
            if (NameOfPharmacy != null)
            {
                IQueryable<MedicineList> Medicines = await Task.Run(() => _pharmacyHeadRepository.GetPharmacyMedicines(NameOfPharmacy));
                if (Medicines != null)
                    return Medicines;
            }
            return null;
        }

        public async void Remove(PharmacyHead pharmacyHead)
        {
            if (pharmacyHead != null)
                await Task.Run(() => _pharmacyHeadRepository.Remove(pharmacyHead));
            else throw new Exception("Can't remove, name of pharmacy head is null.");
        }
    }
}
