﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using System.Collections.Generic;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using Microsoft.Extensions.Logging;
using System.Net;
using System.Linq;
using FarmatikoServices.FarmatikoServiceInterfaces;
using RestSharp;
using System.Threading.Tasks;

namespace FarmatikoServices.Services
{
    public class ProcessJSONService : IProcessJSONService
    {
        private IHealthFacilityRepository _healthFacilityRepository;
        private IPandemicRepository _pandemicRepository;
        private IHealthcareWorkerRepository _healthcareWorkerRepository;
        private IMedicineRepository _medicineRepository;
        private readonly ILogger _logger;
        public ProcessJSONService(IHealthFacilityRepository healthFacilityRepository, IPandemicRepository pandemicRepository,
            IHealthcareWorkerRepository healthcareWorkerRepository, IMedicineRepository medicineRepository, ILogger logger)
        {
            _logger = logger;
            _healthFacilityRepository = healthFacilityRepository;
            _pandemicRepository = pandemicRepository;
            _healthcareWorkerRepository = healthcareWorkerRepository;
            _medicineRepository = medicineRepository;
        }

        public async Task<HashSet<HealthFacilities>> GetProcessedHealthFacilitiesFromJSON()
        {
            try
            {
                HashSet<HealthFacilities> hashSet = new HashSet<HealthFacilities>();
                var client = new WebClient();
                var json = client.DownloadString(@"C:\Users\dslez\Desktop\ustanovi.json");

                var jsonResponse = JObject.Parse(json);
                var records = JArray.Parse(jsonResponse.GetValue("records").ToString());

                foreach (var rec in records)
                {
                    dynamic obj = JsonConvert.DeserializeObject(rec.ToString());
                    var Name = obj[2];
                    var Municipality = obj[6];
                    var Address = obj[9];
                    var Email = obj[10];
                    var Phone = obj[11];
                    var Type = obj[5];
                    HealthFacilities healthFacility = new HealthFacilities(Name, Municipality, Address, Type, Email, Phone);
                    /*healthFacility.Name = Name;
                    healthFacility.Municipality = Municipality;
                    healthFacility.Address = Address;
                    healthFacility.Email = Email;
                    healthFacility.Phone = Phone;
                    healthFacility.Type = Type;*/
                    //hashSet.Add(healthFacility);
                    await Task.Run(() => _healthFacilityRepository.Add(healthFacility));

                }

            }
            catch (Exception e)
            {
                _logger.LogInformation(e.Message);
                throw new Exception("Cannot process health facilities from JSON.");
            }
            return null;
        }

        public async Task<HashSet<Pandemic>> GetProcessedPandemicsFromJSONApi()
        {
            try
            {
                var client = new RestClient("https://api.covid19api.com/summary");
                var response = client.Execute(new RestRequest());
                string original = response.Content;
                var jsonResponsePandemic = JObject.Parse(original);
                var global = JObject.Parse(jsonResponsePandemic.GetValue("Global").ToString());
                var TotalConfirmed = long.Parse(global.GetValue("TotalConfirmed").ToString());
                var TotalDeaths = long.Parse(global.GetValue("TotalDeaths").ToString());
                var TotalRecovered = long.Parse(global.GetValue("TotalRecovered").ToString());

                var mk = JArray.Parse(jsonResponsePandemic.GetValue("Countries").ToString());
                dynamic objP = mk[100];
                var TotalMk = Int32.Parse(objP.GetValue("TotalConfirmed").ToString());
                var TotalDeathsMK = Int32.Parse(objP.GetValue("TotalDeaths").ToString());
                var TotalRecoveredMK = Int32.Parse(objP.GetValue("TotalRecovered").ToString());
                var NewMK = Int32.Parse(objP.GetValue("NewConfirmed").ToString());

                var Name = "Coronavirus";
                var ActiveMk = TotalMk - (TotalRecoveredMK + TotalDeathsMK);
                var ActiveGlobal = TotalConfirmed - (TotalRecovered + TotalDeaths);

                Pandemic pandemic = new Pandemic(Name, TotalMk, ActiveMk, TotalDeathsMK, NewMK, TotalConfirmed, TotalDeaths, ActiveGlobal);
                /*pandemic.TotalGlobal = TotalConfirmed;
                pandemic.ActiveGlobal = TotalConfirmed - (TotalRecovered + TotalDeaths);
                pandemic.DeathsGlobal = TotalDeaths;
                pandemic.TotalMK = TotalMk;
                pandemic.ActiveMK = TotalMk - (TotalRecoveredMK + TotalDeathsMK);
                pandemic.DeathsMK = TotalDeathsMK;
                pandemic.NewMK = NewMK;
                pandemic.Name = "Coronavirus";*/
                await Task.Run(() => _pandemicRepository.Add(pandemic));
            }
            catch (Exception e)
            {
                _logger.LogInformation(e.Message);
            }
            return null;
        }

        public async Task<HashSet<HealthcareWorkers>> GetProcessedHealthcareWorkersFromJSON()
        {
            try
            {
                var client = new WebClient();
                var jsonW = client.DownloadString(@"C:\Users\dslez\Desktop\rabotnici.json");

                var jsonResponseW = JObject.Parse(jsonW);
                var recordsW = JArray.Parse(jsonResponseW.GetValue("records").ToString());

                foreach (var rec in recordsW)
                {
                    dynamic obj = JsonConvert.DeserializeObject(rec.ToString());
                    var Name = obj[4];
                    var Branch = obj[2];
                    var FacilityName = obj[1];
                    var Title = obj[3];
                    HealthFacilities facility = _healthFacilityRepository.GetByName(FacilityName);
                    HealthFacilities Facility = new HealthFacilities(facility.Name, facility.Municipality, facility.Address,
                                                                        facility.Type, facility.Email, facility.Phone);
                    HealthcareWorkers healthcareWorker = new HealthcareWorkers(Name, Branch, Facility, Title);
                    /*Facility.Name = obj[1];
                    Facility.Municipality = "WorkerFacilityMunicipality";
                    Facility.Address = "WorkerFacilityAddress";*/
                    /*healthcareWorker.Name = Name;
                    healthcareWorker.Branch = Branch;
                    healthcareWorker.Facility = Facility;
                    healthcareWorker.Title = Title;*/
                    await Task.Run(() => _healthcareWorkerRepository.Add(healthcareWorker));
                }
            }
            catch (Exception e)
            {
                _logger.LogInformation(e.Message);
            }
            return null;
        }

        public async Task<HashSet<Medicine>> GetProcessedMedicinesFromJSON()
        {
            try
            {
                var client = new WebClient();
                var jsonM = client.DownloadString(@"C:\Users\dslez\Desktop\lekovi.json");

                var jsonResponseM = JObject.Parse(jsonM);
                var recordsM = JArray.Parse(jsonResponseM.GetValue("records").ToString());

                foreach (var rec in recordsM)
                {
                    dynamic obj = JsonConvert.DeserializeObject(rec.ToString());
                    var Name = obj[1];
                    var Strength = obj[7];
                    var Form = obj[6];
                    var WayOfIssuing = obj[9];
                    var Manufacturer = obj[11];
                    var Price = float.Parse(obj[17]);
                    var Packaging = obj[8];
                    Medicine medicine = new Medicine(Name, Strength, Form, WayOfIssuing, Manufacturer, Price, Packaging);
                    /*medicine.Name = Name;
                    medicine.Strength = Strength;
                    medicine.Form = Form;
                    medicine.WayOfIssuing = WayOfIssuing;
                    medicine.Manufacturer = Manufacturer;
                    medicine.Price = Price;
                    medicine.Packaging = Packaging;*/
                    await Task.Run(() => _medicineRepository.Add(medicine));
                }
            }
            catch (Exception e)
            {
                _logger.LogInformation(e.Message);
            }
            return null;
        }
    }
}
