﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.Models;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace FarmatikoData.FarmatikoRepo
{
    public class PHRepo : IPHRepo
    {
        private readonly FarmatikoDataContext _context;
        public PHRepo(FarmatikoDataContext context)
        {
            _context = context;
        }
        //GET
        public async Task<PharmacyHead> GetPharmacyHeadByIdAsync(int id)
        {
            var Phead = await _context.PharmacyHeads.Where(x => x.Id == id).FirstOrDefaultAsync();
            return Phead;
        }

        public async Task<IEnumerable<PharmacyHead>> GetPharmacyHeadInfo()
        {
            var PHeadInfo = await _context.PharmacyHeads.Take(10).Where(x => x.DeletedOn == null)
                .Select(x => new PharmacyHead
                {
                    Id = x.Id,
                    Name = x.Name,
                    Email = x.Email,
                    Password = x.Password,
                    MedicineLists = x.MedicineLists,
                    PharmaciesList = x.PharmaciesList
                }).ToListAsync();
            return PHeadInfo;
        }
        //POST
        public async Task UpdatePharmacyHead(PharmacyHead pharmacyHead)
        {
            var EditedPHead = await _context.PharmacyHeads.Where(x => x.Id == pharmacyHead.Id).FirstOrDefaultAsync();
            EditedPHead.Email = pharmacyHead.Email;
            EditedPHead.Name = pharmacyHead.Name;
            EditedPHead.Password = pharmacyHead.Password;
            EditedPHead.MedicineLists = pharmacyHead.MedicineLists;
            EditedPHead.PharmaciesList = pharmacyHead.PharmaciesList;
            await _context.SaveChangesAsync();
        }
        public async Task ClaimPharmacy(RequestPharmacyHead pharmacy)
        {
            await _context.PHRequests.AddAsync(pharmacy);
            await _context.SaveChangesAsync();
        }
        public async Task Add(PharmacyHead pharmacyHead)
        {
            await _context.PharmacyHeads.AddAsync(pharmacyHead);
            await _context.SaveChangesAsync();
        }

        public async Task Remove(PharmacyHead phead)
        {
            var Phead = await _context.PharmacyHeads.Where(x => x.Id == phead.Id).FirstOrDefaultAsync();
            Phead.DeletedOn = phead.DeletedOn;
            await _context.SaveChangesAsync();
        }

        public async Task RemoveClaimingRequest(int id)
        {
            var req = await _context.PHRequests.Where(r => r.Id == id).FirstOrDefaultAsync();
            _context.PHRequests.Remove(req);
            await _context.SaveChangesAsync();
        }

        public PharmacyHead GetPharmacyHeadByUserName(string userName)
        {
            return _context.PharmacyHeads
                .Where(x => x.Email.Equals(userName))
                .FirstOrDefault();
        }
    }
}
