﻿using FarmatikoData;
using FarmatikoData.Models;
using Microsoft.AspNetCore.Mvc;
using System.Collections.Generic;

namespace Farmatiko.Controllers
{
    [ApiController]
    [Route("[controller]/[action]")]
    public class HealthFacilitiesController : Controller
    {
        private IHealthFacilityService _healthFacilitiesService;
        public HealthFacilitiesController(IHealthFacilityService healthFacilitiesService)
        {
            _healthFacilitiesService = healthFacilitiesService;
        }
        [HttpGet]
        public IEnumerable<HealthFacilities> Get()
        {
            return _healthFacilitiesService.GetAll();
        }
        [HttpGet]
        public IEnumerable<HealthFacilities> GetByName(string Name)
        {
            return _healthFacilitiesService.GetByName(Name);
        }
        
        [HttpGet]
        public IEnumerable<HealthFacilities> GetByType(string Type)
        {
            return _healthFacilitiesService.GetByType(Type);
        }
        [HttpPut]
        public void Add(HealthFacilities healthFacility)
        {
            _healthFacilitiesService.Add(healthFacility);
        }
    }
}
