﻿using Microsoft.AspNetCore.Mvc;
using FarmatikoData.FarmatikoServiceInterfaces;
using System.Collections.Generic;
using FarmatikoData.Models;

namespace Farmatiko.Controllers
{
    public class HealthcareWorkerController : Controller
    {
        private IHealthcareWorkerService _healthcareWorkerService;
        public HealthcareWorkerController(IHealthcareWorkerService healthcareWorkerService)
        {
            _healthcareWorkerService = healthcareWorkerService;
        }

        [HttpGet]
        public IEnumerable<HealthcareWorkers> GetAll()
        {
            return _healthcareWorkerService.GetAll();
        }
        [HttpGet]
        public HealthcareWorkers GetByName(string Name)
        {
            return _healthcareWorkerService.GetByName(Name);
        }
        [HttpGet]
        public IEnumerable<HealthcareWorkers> GetAllByBranch(string Branch)
        {
            return _healthcareWorkerService.GetAllByBranch(Branch);
        }
        [HttpGet]
        public IEnumerable<HealthcareWorkers> GetAllByFacility(HealthFacilities Facility)
        {
            return _healthcareWorkerService.GetAllByFacility(Facility);
        }
        [HttpGet]
        public void Add(HealthcareWorkers HealthcareWorker)
        {
            _healthcareWorkerService.Add(HealthcareWorker);
        }
    }
}
