﻿using FarmatikoData.FarmatikoRepoInterfaces;
using FarmatikoData.FarmatikoServiceInterfaces;
using FarmatikoData.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace FarmatikoServices.Services
{
    public class HealthcareWorkerService : IHealthcareWorkerService
    {
        private IHealthcareWorkersRepository _workersRepository;
        public HealthcareWorkerService(IHealthcareWorkersRepository workersRepository)
        {
            _workersRepository = workersRepository;
        }
        public void Add(HealthcareWorkers HealthcareWorker)
        {
            _workersRepository.Add(HealthcareWorker);
        }

        public IEnumerable<HealthcareWorkers> GetAll()
        {
            return _workersRepository.GetAll();
        }

        public IEnumerable<HealthcareWorkers> GetAllByBranch(string Branch)
        {
            return _workersRepository.GetByBranch(Branch);
        }

        public IEnumerable<HealthcareWorkers> GetAllByFacility(HealthFacilities Facility)
        {
            return _workersRepository.GetByFacility(Facility);
        }

        public HealthcareWorkers GetByName(string Name)
        {
            return _workersRepository.GetByName(Name);
        }
    }
}
