import { Component, OnInit, Inject, Output, EventEmitter } from '@angular/core';
import { Pharmacy } from '../models/Pharmacy';
import { HttpClient } from '@angular/common/http';
import { MatDialog } from '@angular/material/dialog';
import { MatSnackBar, MatSnackBarRef, SimpleSnackBar } from '@angular/material/snack-bar';
import { Router, RouterModule } from '@angular/router';
import { PharmacyHead } from '../models/PharmacyHead';
import { FormControl } from '@angular/forms';


@Component({
  selector: 'app-admin',
  templateUrl: './admin.component.html',
  styleUrls: ['./admin.component.css']
})
export class AdminComponent implements OnInit {
  public heads: PharmacyHead[];
  public head: PharmacyHead;
  public status: string;

  constructor(http: HttpClient, @Inject('BASE_URL') baseUrl: string, private dialog: MatDialog, private _snackBar: MatSnackBar, private router: Router) {
    http.get<PharmacyHead[]>(baseUrl + 'PharmacyHead/Get?').subscribe(result => {
      this.heads = result;
      console.log(this.heads);
    }, error => console.error(error));
  }

  ngOnInit(): void {
    this.head = new PharmacyHead();
  }

  createHead() {
    console.log(this.head);
    // post request vo prodolzenie

    this.status="Status bar createHead";
    //window.location.reload();
  }

  Del(head: PharmacyHead) {
    console.log(this.head);
    // post request vo prodolzenie

    this.status="Status bar Del";
  }

  ChangeDialog(head: PharmacyHead) {
    console.log(this.head);

  }

  Reject() {
    console.log('Rejected');
    // post request vo prodolzenie

  }

  Approve() {
    console.log('Approved');
    // post request vo prodolzenie

  }

}
